/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
/**
 * \file    aic3106.c
 *
 * \brief   Routines to initialize the AIC3106 Audio Coded
 *
 * This file contains the routines for configuring and
 * accessing the AIC3106 Audio Codec
 *
 * \author  0043
 *
 * \version 01a,13aug,2010 Created
 */

/*
 *====================
 * Includes
 *====================
 */
#include "dm388_i2c.h"
#include "aic3104.h"
  
/*
 *====================
 * Function implementations
 *====================
 */
/** **************************************************************************
 * \n \brief Routine to set the register value in the AIC3106 Codec
 *
 * This routine initializes the I2C instance 0. We are not configuring the 
 * interrupts here as the code is intended to carry out all I/O operations
 * in polled mode.
 *
 * \param u8RegNum		[IN]	Bus Instance number
 * \param u8RegVal		[IN]	Value to be written
 *
 * \return
 * \n      return SUCCESS for success  - Description
 * \n      return FAILED for error   - Description
 */
INT32 aic3104RegSet
(
	UINT8	u8RegNum,
	UINT8  	u8RegVal
)
{
	INT32 u32RetVal = SUCCESS;
	UINT8  u8DataWritten = 0;
	
	UINT8	au8Cmd[32];
	
	au8Cmd[0] = u8RegNum & AIC3104_REG_ADDR_MASK;
	au8Cmd[1] = u8RegVal;

	u32RetVal = DM388I2cWite(AIC3104_I2C_BUS_NUM,
								AIC3104_I2C_ADDR,
								au8Cmd,
								2,
								&u8DataWritten );
	

	return (u32RetVal);
}
